# Szyfrowanie i deszyfrowanie pliku za pomocą szyfru przestawieniowego:
# https://www.nostarch.com/crackingcodes (na licencji BSD).

import time, os, sys, transpositionEncrypt, transpositionDecrypt

def main():
    inputFilename = 'frankenstein.txt'
    # ZACHOWAJ OSTROŻNOŚĆ! Jeżeli plik wymieniony w zmiennej outputFilename
    # już istnieje, ten program nadpisze jego zawartość.
    outputFilename = 'frankenstein.encrypted.txt'
    myKey = 10
    myMode = 'szyfrowanie'  # Przypisanie wartości 'szyfrowanie' lub 'deszyfrowanie'.

    # Jeżeli plik danych wejściowych nie istnieje, program zakończy działanie.
    if not os.path.exists(inputFilename):
        print('Plik %s nie istnieje. Koniec pracy programu...' % (inputFilename))
        sys.exit()

    # Jeżeli plik danych wyjściowych już istnieje, należy umożliwić użytkownikowi zakończenie działania programu.
    if os.path.exists(outputFilename):
        print('To spowoduje nadpisanie pliku %s. (K)ontynuować czy (Z)akończyć pracę?' % (outputFilename))
        response = input('> ')
        if not response.lower().startswith('k'):
            sys.exit()

    # Odczyt tekstu z pliku danych wejściowych.
    fileObj = open(inputFilename)
    content = fileObj.read()
    fileObj.close()

    print('%s...' % (myMode.title()))

    # Pomiar czasu operacji szyfrowania i deszyfrowania.
    startTime = time.time()
    if myMode == 'szyfrowanie':
        translated = transpositionEncrypt.encryptMessage(myKey, content)
    elif myMode == 'deszyfrowanie':
        translated = transpositionDecrypt.decryptMessage(myKey, content)
    totalTime = round(time.time() - startTime, 2)
    print('%s trwało %s sekundy' % (myMode.title(), totalTime))

    # Zapisanie przetworzonego tekstu w pliku danych wyjściowych.
    outputFileObj = open(outputFilename, 'w')
    outputFileObj.write(translated)
    outputFileObj.close()

    print('Zakończono %s pliku %s (%s znaki).' % (myMode, inputFilename, len(content)))
    print('%s wygenerowało plik %s.' % (myMode.title(), outputFilename))


# Jeżeli program transpositionCipherFile.py został uruchomiony (a nie
# importowany jako moduł), wówczas należy wywołać funkcję main().
if __name__ == '__main__':
    main()
